/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: VARANStack_Functionlist.h $
   Last Modification:
    $Author: Dimitar $
    $Modtime: 10.03.06 18:51 $
    $Revision: 10 $
   
   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes
 
   Description:
     
    VARAN Stack
    Task function list for configuration file
       
   Changes:
 
     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
        
**************************************************************************************/
/**
 * @file VARANStack_Functionlist.h
 * @brief VARAN Stack - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_VARANStack</code>
 * of task.
 */
#ifndef __VARAN_CLIENT_FUNCTIONLIST_H
#define __VARAN_CLIENT_FUNCTIONLIST_H

/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */

TLR_RESULT
TaskExit_VARANStack
(
 TLR_VOID FAR* pvRsc
);

TLR_RESULT
TaskLeave_VARANStack
(
 TLR_VOID FAR* pvRsc,
 TLR_VOID FAR* pvLve
);
                                             
TLR_VOID
TaskEnter_VARANStack
(
 TLR_VOID FAR* pvInit
);

/** @} */


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define VARAN_CLIENT_STARTUP_PARAM_VERSION (1)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */


/** task startup parameter */
typedef struct VARAN_CLIENT_STARTUPPARAMETER_Ttag  VARAN_CLIENT_STARTUPPARAMETER_T;


/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */

struct VARAN_CLIENT_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_TASK_PARAMETERHEADER;
};


/** task startup parameter */
//typedef struct VRS_STARTUPPARAMETER_Ttag  VRS_STARTUPPARAMETER_T

/** @} */
/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */

#define VARAN_CLIENT_TASK_NAME          "VARANStack"
#define VARAN_CLIENT_STACK_SIZE         (2048)


#define TLR_TASK_VARAN_STACK      (0x009C0000)

//  #if (defined ENABLE_VARAN_CLIENT)
//  {"VARAN_CLIENT_TASK_NAME",         /* Set Identification */
//   TSK_PRIO_50, TSK_TOK_50,          /* Set Priority,and Token ID */
//   0,                                /* Set Instance to 0 */
//   0,                                /* Pointer to Stack */
//   VARAN_CLIENT_STACK_SIZE,          /* Size of Task Stack */
//   0,                                /* Threshold to maximum possible value */
//   RX_TASK_AUTO_START,               /* Start task automatically */
//   (void*)TaskEnter_VARANStack,      /* Task function to schedule */
//   (void*)TaskExit_VARANStack,       /* Function called when Task will be deleted */
//    0,                               /* Startup Parameter */
//   {0,0,0,0,0,0,0,0}                 /* Reserved Region */
//  },
//#endif


/*************************************************************************************/
#endif /* #ifndef __VARAN_CLIENT_FUNCTIONLIST_H */
